# This is the list of Theme Options planned to be implemented on the future

function UserJudgmentLabel()
	local t = {
		Name = "UserJudgementLabel",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = true,
		ExportOnChange = false,
		Choices = { 'StepMania Tacvicom Edition','Dance Dance Revolution','Dance Dance Revolution SuperNOVA','D3NEX','Cyberia Style','In The Groove','Pump It Up' },
		LoadSelections = function(self, list, pn)
			if GetUserPref_Theme("UserJudgementLabel") ~= nil then
				if GetUserPref_Theme("UserJudgementLabel") == 'Dance Dance Revolution' then
					list[2] = true
				elseif GetUserPref_Theme("UserJudgementLabel") == 'Dance Dance Revolution SuperNOVA' then
					list[3] = true
				elseif GetUserPref_Theme("UserJudgementLabel") == 'D3NEX' then
					list[4] = true
				elseif GetUserPref_Theme("UserJudgementLabel") == 'Cyberia Style' then
					list[5] = true
				elseif GetUserPref_Theme("UserJudgementLabel") == 'In The Groove' then
					list[6] = true
				elseif GetUserPref_Theme("UserJudgementLabel") == 'Pump It Up' then
					list[7] = true
				else
					list[1] = true
				end;
			else
				list[1] = true
			end
		end,
		SaveSelections = function(self, list, pn)
			local bSave;
			if list[2] then
				bSave='Dance Dance Revolution';
			elseif list[3] then
				bSave='Dance Dance Revolution SuperNOVA';
			elseif list[4] then
				bSave='D3NEX';
			elseif list[5] then
				bSave='Cyberia Style';
			elseif list[6] then
				bSave='In The Groove';
			elseif list[7] then
				bSave='Pump It Up';
			else
				bSave='StepMania Tacvicom Edition';
			end;
			SetUserPref_Theme("UserJudgementLabel", bSave);
		end
	}
	setmetatable(t, t)
	return t
end